% Function to draw the snowflakes throughout the array
function model = draw_snowflakes_hexagon(geom, model, workplane)

x_cen = geom.mech.amech/2;
y_cen = 0;
[snowflake_cen_x, snowflake_cen_y] = coordinates_round_snowflake_comsol(x_cen, y_cen, geom.mech.r, geom.mech.w, geom.mech.rad_curv, geom.mech.rad_curv2, geom.mech.resolution);

mech = workplane.geom.create('pol2', 'Polygon');
mech.set('source', 'table');
for pol_i=1:length(snowflake_cen_x(1:end-1))
    mech.setIndex('table', num2str(snowflake_cen_x(pol_i),'%10.9e'), pol_i-1, 0);  %value,row, coloumn
    mech.setIndex('table', num2str(snowflake_cen_y(pol_i),'%10.9e'), pol_i-1, 1);
end

copy = workplane.geom.create('cp_sf_1', 'Copy');
copy.selection('input').set({'pol2'});
copy.set('displx', num2str(geom.mech.amech/2,'%10.9e'));
copy.set('disply', num2str(-geom.mech.amech*sqrt(3)/2,'%10.9e'));

copy = workplane.geom.create('cp_sf_2', 'Copy');
copy.selection('input').set({'pol2'});
copy.set('displx', num2str(-geom.mech.amech/2,'%10.9e'));
copy.set('disply', num2str(-geom.mech.amech*sqrt(3)/2,'%10.9e'));

arr = workplane.geom.create('arr1', 'Array');
arr.selection('input').set({'pol2'});
arr.set('fullsize', [1 geom.stack.num_domy+1]);
arr.set('displ', {'0' num2str(-geom.mech.amech*sqrt(3),'%10.9e')});

arr = workplane.geom.create('arr2', 'Array');
arr.selection('input').set({'cp_sf_1' 'cp_sf_2'});
arr.set('fullsize', [1 geom.stack.num_domy]);
arr.set('displ', {'0' num2str(-geom.mech.amech*sqrt(3),'%10.9e')});

end